<?php
/**
 * Core plugin orchestrator.
 *
 * @package Fox4A11y
 */

namespace Fox4A11y;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Singleton that wires Settings and Frontend together.
 */
final class Plugin {

	/** @var self|null */
	private static $instance = null;

	/**
	 * Return the single instance.
	 */
	public static function instance(): self {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor — load dependencies and hook into WordPress.
	 */
	private function __construct() {
		$this->load_textdomain();
		$this->load_dependencies();
	}

	/**
	 * Load plugin text domain for i18n.
	 */
	private function load_textdomain(): void {
		load_plugin_textdomain(
			'2fox4-accessibility',
			false,
			dirname( plugin_basename( FOX4A11Y_FILE ) ) . '/languages'
		);
	}

	/**
	 * Require class files and instantiate.
	 */
	private function load_dependencies(): void {
		require_once FOX4A11Y_DIR . 'inc/class-settings.php';
		require_once FOX4A11Y_DIR . 'inc/class-frontend.php';

		new Settings();
		new Frontend();
	}

	/**
	 * Helper to retrieve a plugin option with fallback.
	 *
	 * @param string $key     Option key inside fox4a11y_settings.
	 * @param mixed  $default Fallback value.
	 * @return mixed
	 */
	public static function get_option( string $key, $default = '' ) {
		$opts = get_option( 'fox4a11y_settings', array() );
		return $opts[ $key ] ?? $default;
	}
}
