<?php
/**
 * Plugin Name:       2fox4 Accessibility Suite
 * Plugin URI:        https://www.2fox4.de/wordpress-plugins/
 * Description:       A professional WCAG 2.1/2.2 accessibility toolkit with a floating widget for font resizing, contrast modes, reading guide, and more.
 * Version:           1.0.9
 * Requires at least: 6.9
 * Requires PHP:      7.4
 * Author:            Oliver Deppe
 * Author URI:        https://www.2fox4.de/wordpress-plugins/
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       2fox4-accessibility
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'FOX4A11Y_VERSION', '1.0.9' );
define( 'FOX4A11Y_FILE', __FILE__ );
define( 'FOX4A11Y_DIR', plugin_dir_path( __FILE__ ) );
define( 'FOX4A11Y_URL', plugin_dir_url( __FILE__ ) );

require_once FOX4A11Y_DIR . 'inc/class-plugin.php';

/**
 * Boot the plugin.
 */
function fox4a11y_init() {
	return Fox4A11y\Plugin::instance();
}
add_action( 'plugins_loaded', 'fox4a11y_init' );

/**
 * Register default options on activation.
 */
function fox4a11y_activate() {
	$defaults = array(
		'accent_color' => '#007AFF',
		'position'     => 'bottom-right',
	);
	if ( false === get_option( 'fox4a11y_settings' ) ) {
		add_option( 'fox4a11y_settings', $defaults );
	}
}
register_activation_hook( __FILE__, 'fox4a11y_activate' );
